#ifndef CRC_CACHE_DEFS_H
#define CRC_CACHE_DEFS_H

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
//                                                                            //
// This file is distributed as part of the Cache Replacement Championship     //
// workshop held in conjunction with ISCA'2010.                               //
//                                                                            //
//                                                                            //
// Everyone is granted permission to copy, modify, and/or re-distribute       //
// this software.                                                             //
//                                                                            //
// Please contact Aamer Jaleel <ajaleel@gmail.com> should you have any        //
// questions                                                                  //
//                                                                            //
////////////////////////////////////////////////////////////////////////////////

// --- DO NOT EDIT THIS FILE --- DO NOT EDIT THIS FILE --- DO NOT EDIT THIS FILE ---
// --- DO NOT EDIT THIS FILE --- DO NOT EDIT THIS FILE --- DO NOT EDIT THIS FILE ---
// --- DO NOT EDIT THIS FILE --- DO NOT EDIT THIS FILE --- DO NOT EDIT THIS FILE ---

// IMPORTANT NOTE: DO NOT CHANGE ANYTHING IN THIS HEADER FILE. Changing anything
// in here will violate the competition rules.

typedef struct
{
    bool        valid;       // Is line valid?
    Addr_t      tag;         // Tag of line
    bool        dirty;       // Is line dirty?
    BITVECTOR   sharing_dir; // Directory of which core accessed this line
} LINE_STATE;

typedef enum 
{
    ACCESS_IFETCH      = 0,
    ACCESS_LOAD        = 1,
    ACCESS_STORE       = 2,
    ACCESS_UNSUPPORT0  = 3,
    ACCESS_UNSUPPORT1  = 4,
    ACCESS_PREFETCH    = 5,
    ACCESS_WRITEBACK   = 6,
    ACCESS_MAX         = 7
} AccessTypes;

#define IS_STORE(X)  (X == ACCESS_STORE || X == ACCESS_WRITEBACK);

#endif
